﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace CRR_Example_Client
{
    public partial class frmConnectionEdit : Form
    {
        public frmConnectionEdit()
        {
            InitializeComponent();

            cmbProtocol.Items.Add(ProtocolType.HTTP);
            cmbProtocol.Items.Add(ProtocolType.HTTPS);
            cmbProtocol.SelectedItem = ProtocolType.HTTP;
            txtAddress.Text = "";
        }

        public frmConnectionEdit(ProtocolType p, string a) : this()
        {
            cmbProtocol.SelectedItem = p;
            txtAddress.Text = a;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = System.Windows.Forms.DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = System.Windows.Forms.DialogResult.Cancel;
            Close();
        }

        public ProtocolType GetProtocol()
        {
            return (ProtocolType)cmbProtocol.SelectedItem;
        }

        public string GetAddress()
        {
            return txtAddress.Text;
        }
    }
}
